#!/bin/sh

if [ ! -e /bin/vim-cmd ]; then
	VIMCMD="/usr/bin/vim-cmd";
else
	VIMCMD="/bin/vim-cmd";
fi

if [ "${#}" != 2 ]; then
    printf "Usage:\n\t`basename ${0}` [origin_vmx_full_path] [postfix_name]\n";
    echo "e.g.:";
    printf "\t${0} /vmfs/volumes/datastore1/sandbox/sandbox.vmx ORIGIN\n";
    exit 1
fi

change_pure_vm_dir () {

    local src_vmdk="$(echo ${1} | sed 's/\.vmx$/.vmdk/g')";
    local src_postfix=${2};

    local datastore1=${src_vmdk%/*/*};
    local src_prefix=$(basename ${src_vmdk} | sed 's/\.vmdk$//g');
    local src_dir="${datastore1}/${src_prefix}_${src_postfix}/";
	local dst_dir="${datastore1}/${src_prefix}/"

    # delete the drop file
    [ -e "${src_dir}/ORIGIN" ] && rm -f "${src_dir}/ORIGIN"
	
	/bin/mv ${src_dir} ${dst_dir}
}

change_pure_vm_dir ${1} ${2}
exit 0

